package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Secuencias;
import com.ejie.ab04b.model.EmpresaServicioPrevencion;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0480s00DaoImpl generated by UDA, 19-Jan-2017 11:07:18.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class EmpresaServicioPrevencionDaoImpl implements
		EmpresaServicioPrevencionDao {

	private JdbcTemplate jdbcTemplate;

	private static final String QUERY_SELECT = "SELECT t1.CODPREV_080 CODPREV080, t1.DESPREV_EU_080 DESPREVEU080, t1.DESPREV_ES_080 DESPREVES080, t1.FECBAJ_080 FECBAJ080 FROM AB0480S00 t1 ";

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<EmpresaServicioPrevencion> rwMap = new RowMapper<EmpresaServicioPrevencion>() {
		public EmpresaServicioPrevencion mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new EmpresaServicioPrevencion(
					resultSet.getString("CODPREV080"),
					resultSet.getString("DESPREVEU080"),
					resultSet.getString("DESPREVES080"),
					resultSet.getDate("FECBAJ080"));
		}
	};

	private RowMapper<EmpresaServicioPrevencion> rwMapPK = new RowMapper<EmpresaServicioPrevencion>() {
		public EmpresaServicioPrevencion mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new EmpresaServicioPrevencion(
					resultSet.getString("CODPREV080"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab0480s00 table.
	 * 
	 *  ab0480s00
	 *            Ab0480s00
	 *  Ab0480s00
	 *
	 * @param ab0480s00 the ab 0480 s 00
	 * @return the empresa servicio prevencion
	 */
	public EmpresaServicioPrevencion add(EmpresaServicioPrevencion ab0480s00) {
		Long empresaAuditoraPK = Secuencias.SERVICIO_PREVENCION
				.getNextLong(this.jdbcTemplate);
		if (empresaAuditoraPK != null) {
			ab0480s00.setCodprev080(empresaAuditoraPK.toString());
		}

		String query = "INSERT INTO AB0480S00 (CODPREV_080, DESPREV_EU_080, DESPREV_ES_080, FECBAJ_080) VALUES (?,?,?,?)";
		this.jdbcTemplate.update(query, ab0480s00.getCodprev080(),
				ab0480s00.getDesprevEu080(), ab0480s00.getDesprevEs080(),
				ab0480s00.getFecbaj080());
		return ab0480s00;
	}

	/**
	 * Updates a single row in the Ab0480s00 table.
	 * 
	 *  ab0480s00
	 *            Ab0480s00
	 *  Ab0480s00
	 *
	 * @param ab0480s00 the ab 0480 s 00
	 * @return the empresa servicio prevencion
	 */
	public EmpresaServicioPrevencion update(EmpresaServicioPrevencion ab0480s00) {
		String query = "UPDATE AB0480S00 SET DESPREV_EU_080=?, DESPREV_ES_080=?, FECBAJ_080=? WHERE CODPREV_080=?";
		this.jdbcTemplate.update(query, ab0480s00.getDesprevEu080(),
				ab0480s00.getDesprevEs080(), ab0480s00.getFecbaj080(),
				ab0480s00.getCodprev080());
		return ab0480s00;
	}

	/**
	 * Finds a single row in the Ab0480s00 table.
	 * 
	 *  ab0480s00
	 *            Ab0480s00
	 *  Ab0480s00
	 *
	 * @param ab0480s00 the ab 0480 s 00
	 * @return the empresa servicio prevencion
	 */
	@Transactional(readOnly = true)
	public EmpresaServicioPrevencion find(EmpresaServicioPrevencion ab0480s00) {
		StringBuilder query = new StringBuilder(
				EmpresaServicioPrevencionDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.CODPREV_080 = ?");

		List<EmpresaServicioPrevencion> ab0480s00List = this.jdbcTemplate
				.query(query.toString(), this.rwMap, ab0480s00.getCodprev080());
		return (EmpresaServicioPrevencion) DataAccessUtils
				.uniqueResult(ab0480s00List);
	}

	/**
	 * Removes a single row in the Ab0480s00 table.
	 * 
	 *  ab0480s00            Ab0480s00
	 *
	 * @param ab0480s00 the ab 0480 s 00
	 */
	public void remove(EmpresaServicioPrevencion ab0480s00) {
		String query = "DELETE FROM AB0480S00 WHERE CODPREV_080=?";
		this.jdbcTemplate.update(query, ab0480s00.getCodprev080());
	}

	/**
	 * Finds a list of rows in the Ab0480s00 table.
	 * 
	 *  ab0480s00
	 *            Ab0480s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0480s00>
	 *
	 * @param ab0480s00 the ab 0480 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<EmpresaServicioPrevencion> findAll(
			EmpresaServicioPrevencion ab0480s00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				EmpresaServicioPrevencionDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0480s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<EmpresaServicioPrevencion>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab0480s00 table using like.
	 * 
	 *  ab0480s00
	 *            Ab0480s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0480s00>
	 *
	 * @param ab0480s00 the ab 0480 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<EmpresaServicioPrevencion> findAllLike(
			EmpresaServicioPrevencion ab0480s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				EmpresaServicioPrevencionDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0480s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<EmpresaServicioPrevencion>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab0480s00 table.
	 * 
	 *  ab0480s00
	 *            Ab0480s00
	 *  Long
	 *
	 * @param ab0480s00 the ab 0480 s 00
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(EmpresaServicioPrevencion ab0480s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0480S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0480s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab0480s00 table using like.
	 * 
	 *  ab0480s00
	 *            Ab0480s00
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param ab0480s00 the ab 0480 s 00
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(EmpresaServicioPrevencion ab0480s00,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0480S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0480s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab0480s00 selected for rup_table.
	 * 
	 *  ab0480s00            Ab0480s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab0480s00>>
	 *
	 * @param ab0480s00 the ab 0480 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<EmpresaServicioPrevencion>> reorderSelection(
			EmpresaServicioPrevencion ab0480s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				EmpresaServicioPrevencionDaoImpl.QUERY_SELECT);
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0480s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, EmpresaServicioPrevencion.class,
				filterParamList,
				"CODPREV_080,DESPREV_EU_080,DESPREV_ES_080,FECBAJ_080");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<EmpresaServicioPrevencion>(
						this.rwMapPK, jqGridRequestDto), filterParamList
						.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 *  filterParams            Ab0480s00
	 *  searchParams            Ab0480s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab0480s00>>
	 *
	 * @param filterParams the filter params
	 * @param searchParams the search params
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<EmpresaServicioPrevencion>> search(
			EmpresaServicioPrevencion filterParams,
			EmpresaServicioPrevencion searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				EmpresaServicioPrevencionDaoImpl.QUERY_SELECT);
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings(value = "unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, EmpresaServicioPrevencion.class,
				filterParamList, searchSQL, searchParamList, from_alias,
				"CODPREV_080,DESPREV_EU_080,DESPREV_ES_080,FECBAJ_080");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<EmpresaServicioPrevencion>(
						this.rwMapPK, jqGridRequestDto), filterParamList
						.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 *  filterab0480s00            Ab0480s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *
	 * @param filterab0480s00 the filterab 0480 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	@Override()
	public void removeMultiple(EmpresaServicioPrevencion filterab0480s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				EmpresaServicioPrevencionDaoImpl.QUERY_SELECT);

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab0480s00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings(value = "unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto,
						EmpresaServicioPrevencion.class, query, params,
						"CODPREV_080,DESPREV_EU_080,DESPREV_ES_080,FECBAJ_080");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0480s00 entity.
	 * 
	 *  ab0480s00            Ab0480s00 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0480s00 the ab 0480 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(EmpresaServicioPrevencion ab0480s00) {

		StringBuilder where = new StringBuilder(
				EmpresaServicioPrevencionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0480s00 != null && ab0480s00.getCodprev080() != null) {
			where.append(" AND t1.CODPREV_080 = ?");
			params.add(ab0480s00.getCodprev080());
		}
		if (ab0480s00 != null && ab0480s00.getDesprevEu080() != null) {
			where.append(" AND t1.DESPREV_EU_080 = ?");
			params.add(ab0480s00.getDesprevEu080());
		}
		if (ab0480s00 != null && ab0480s00.getDesprevEs080() != null) {
			where.append(" AND t1.DESPREV_ES_080 = ?");
			params.add(ab0480s00.getDesprevEs080());
		}
		if (ab0480s00 != null && ab0480s00.getFecbajaDesde() != null) {
			where.append(" AND t1.FECBAJ_080 >= ?");
			params.add(ab0480s00.getFecbajaDesde());
		}
		if (ab0480s00 != null && ab0480s00.getFecbajaHasta() != null) {
			where.append(" AND t1.FECBAJ_080 <= ?");
			params.add(ab0480s00.getFecbajaHasta());
		}
		//where.append(" AND (t1.FECBAJ_080 IS NULL OR t1.FECBAJ_080 > SYSDATE)");

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0480s00 entity.
	 * 
	 *  ab0480s00            Ab0480s00 Bean with the criteria values to filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0480s00 the ab 0480 s 00
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(
			EmpresaServicioPrevencion ab0480s00, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				EmpresaServicioPrevencionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0480s00 != null && ab0480s00.getCodprev080() != null) {
			where.append(" AND UPPER(t1.CODPREV_080) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0480s00.getCodprev080().toUpperCase() + "%");
			} else {
				params.add("%" + ab0480s00.getCodprev080().toUpperCase() + "%");
			}
			where.append(" AND t1.CODPREV_080 IS NOT NULL");
		}
		if (ab0480s00 != null && ab0480s00.getDesprevEu080() != null) {
			where.append(" AND UPPER(t1.DESPREV_EU_080) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0480s00.getDesprevEu080().toUpperCase() + "%");
			} else {
				params.add("%" + ab0480s00.getDesprevEu080().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DESPREV_EU_080 IS NOT NULL");
		}
		if (ab0480s00 != null && ab0480s00.getDesprevEs080() != null) {
			where.append(" AND UPPER(t1.DESPREV_ES_080) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0480s00.getDesprevEs080().toUpperCase() + "%");
			} else {
				params.add("%" + ab0480s00.getDesprevEs080().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DESPREV_ES_080 IS NOT NULL");
		}
		if (ab0480s00 != null && ab0480s00.getFecbajaDesde() != null) {
			where.append(" AND t1.FECBAJ_080 >= ?");
			params.add(ab0480s00.getFecbajaDesde());
		}
		if (ab0480s00 != null && ab0480s00.getFecbajaHasta() != null) {
			where.append(" AND t1.FECBAJ_080 <= ?");
			params.add(ab0480s00.getFecbajaHasta());
		}
		if(ab0480s00 != null && ab0480s00.getFecbajaDesde() == null && ab0480s00.getFecbajaHasta() == null){
			where.append(" AND (t1.FECBAJ_080 IS NULL OR t1.FECBAJ_080 > SYSDATE)");
		}
		
		//where.append(" AND (t1.FECBAJ_080 IS NULL OR t1.FECBAJ_080 > SYSDATE)");

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
